<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/VAT_14.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/Trader.xsd" xmlns:tp="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/Types.xsd" xmlns:tr="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/Trader.xsd" xmlns:vat14="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/VAT_14.xsd" version="1.0"> <xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/> <xsl:output encoding="UTF-8" method="html"/> <xsl:template match="/"> <xsl:apply-templates select="*"/> </xsl:template> <!-- POCZATEK ALL --> <!-- STYL ARKUSZA --> <xsl:template match="*" mode="styl1"> <style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style> <style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style> <style type="text/css">a{color:#3366FF;font-weight:bold;}</style> <style type="text/css">h3{padding:3px;cursor:help;}</style> <style type="text/css">h4,h5,.copyr{text-align:center;}</style> <style type="text/css">caption{font-weight:bold;}</style> <style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style> <style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">#cont{display:none}</style> <style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style> <style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style> <style type="text/css">.nag2{font-size: 20px}</style> <style type="text/css">.cz10 {font-size: 10px}</style> <style type="text/css">.cz12 {	font-size: 12px}</style> <style type="text/css">.cz18 {font-size: 18px}</style> <style type="text/css">.cz16 {font-size: 16px}</style> <style type="text/css">.cz14 {font-size: 14px}</style> </xsl:template> <!-- SZABLON STOPKI --> <xsl:template match="*" mode="stopka"> <xsl:value-of select="name()"/> </xsl:template> <xsl:template match="*"> <!-- ZASTOSOWANIE STYLU --> <xsl:apply-templates mode="styl1" select="*"/> <!-- DEKLARACJE AKCYZOWE --> <xsl:apply-templates mode="dekl_vat14" select="."/> </xsl:template> <!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --> <xsl:template match="*" mode="dekl_vat14"> <xsl:for-each select=" ns1:Header |  ns4:* | vat14:Header | tr:* "> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:apply-templates mode="Ident" select="."/> <!-- SZABLON DLA RODZAJU DEKLARACJI --> <xsl:apply-templates mode="rodz_dekl" select="."/> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:apply-templates mode="rok_mc" select="."/> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:apply-templates mode="PodstawaPrawna" select="."/> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:apply-templates mode="MiejsceDekl" select="."/> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:apply-templates mode="DanePodatnika" select="."/> <!-- SZABLON DOT. KWOTY PODATKU --> <xsl:apply-templates mode="KwotaPodatku" select="."/> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:apply-templates mode="OswPodatnika" select="."/> <!-- SZABLON DOT. ADNOTACJI--> <xsl:apply-templates mode="Adnotacje" select="."/> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:apply-templates mode="Pouczenie" select="."/> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:apply-templates mode="ObjasnieniaAkc" select="."/> <!-- SZABLON DOT. WYROBOW --> <xsl:apply-templates mode="NowaStrona_Zal" select="."/> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:apply-templates mode="Ident" select="."/> <!-- SZABLON DLA RODZAJU DEKLARACJI ZAŁĄCZNIK --> <xsl:apply-templates mode="rodz_dekl_zal" select="."/> <!-- SZABLON DOT.  OKRESU ROK MIESIAC ZAŁACZNIK--> <xsl:apply-templates mode="rok_mc_zal" select="."/> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:apply-templates mode="DanePodatnika_Zal" select="."/> <!-- SZABLON DOT. WYROBOW --> <xsl:apply-templates mode="Wyroby" select="."/> </xsl:for-each> </xsl:template> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:template match="*" mode="Ident"> <table border="1" width="955"> <tr align="left" valign="top"> <td align="left" height="45" valign="middle" width="586"> <span class="cz12"> <b>1. Identyfikator podatkowy NIP/numer PESEL (niepotrzebne skreslić) podatnika </b> </span> </td> <td align="center" valign="middle" width="353"> <span class="nag2"> <b> <xsl:value-of select="@identifier"/> </b> </span> </td> </tr> <tr align="left" valign="top"> <td align="left" height="45" valign="top"> <b>Numer własny:</b> <span class="cz18"> <xsl:value-of select="@selfRef"/> </span> <br/> <b>Data wypełnienia deklaracji:</b> <span class="cz18"> <xsl:value-of select="//@declarationDate"/> </span> </td> <td align="center" valign="bottom"> <xsl:if test="@refNumber"> Nr referencyjny nadany przez System Zefir:<br/> <xsl:value-of select="@refNumber"/> </xsl:if> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT.  RODZAJU DEKLARACJI --> <xsl:template match="*" mode="rodz_dekl"> <xsl:if test="ns1:* | vat14:*"> <table border="1" width="956"> <tr> <td colspan="3" height="40"> <span class="nag1">VAT-14</span> </td> </tr> <tr> <td> <div align="center"> <span class="nag1">DEKLARACJA O NALEŻNYCH KWOTACH PODATKU OD TOWARÓW I USŁUG W PRZYPADKU WEWNĄTRZWSPÓLNOTOWEGO NABYCIA PALIW SILNIKOWYCH</span> <br/> <span class="nag1"/> </div> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:template match="*" mode="rok_mc"> <table border="1" width="955"> <tr> <td height="49" width="227"/> <td align="left" valign="top" width="135"> <b>4. Miesiac</b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(//@period,6,7)"/> </div> </td> <td align="left" valign="top" width="131"> <b>5. Rok </b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(//@period,1,4)"/> </div> </td> <td width="226"/> <td align="left" valign="top" width="226"> <b>6. Liczba załaczników VAT-14/A<sub>1)</sub> </b> <br/> <div align="center" class="cz18"> <xsl:value-of select=".//@formNo"/> </div> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:template match="*" mode="PodstawaPrawna"> <xsl:if test="ns1:* | vat14:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td align="left" valign="top" width="115">Podstawa prawna: </td> <td align="left" valign="top" width="824">Art. 99 ust. 11a ustawy z dnia 11 marca 2004 r. o podatku od towarów i usług (Dz. U. z 2016 r. poz. 710, z późn. zm.)) zwanej dalej "ustawą".</td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Składający:</td> <td align="left" valign="top">Podatnicy lub płatnicy, o których mowa w art. 99 ust. 11a ustawy. </td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Termin składania:</td> <td align="left" valign="top">Do 5. dnia miesiąca następującego po miesiącu, w którym powstał obowiązek zapłaty podatku. </td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Miejsce składania: </td> <td align="left" valign="top">Naczelnik urzędu celnego właściwy dla rozliczeń podatku akcyzowego.</td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:template match="*" mode="MiejsceDekl"> <xsl:if test="ns1:* | vat14:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag1">A. MIEJSCE I CEL SKŁADANIA DEKLARACJI</span> </td> </tr> <tr align="left"> <td bgcolor="#CCCCCC" rowspan="2" width="40"/> <td align="left" rowspan="2" valign="top" width="425"> <b>7. Naczelnik urzędu celnego, do którego adresowana jest deklaracja</b> <br/> <br/> <span class="cz18"> <xsl:value-of select="@customsOffice"/> </span> </td> <td align="left" colspan="2" valign="top"> <b>8. Cel złożenia formularza </b>(zaznaczyć właściwy kwadrat):</td> </tr> <tr> <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Deklaracja'"> <td align="left" valign="top">1. złożenie deklaracji <br/> <span class="cz18"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> </td> </xsl:if> <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Korekta'"> <td align="left" valign="top">2. korekta deklaracji <br/> <span class="cz18"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> <br/> <xsl:value-of select="@justification"/> </td> </xsl:if> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:template match="*" mode="DanePodatnika"> <xsl:if test="ns1:* | vat14:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="5"> <span class="nag1">B. DANE IDENTYFIKACYJNE PODATNIKA/PŁATNIKA</span> <br/> *- dotyczy podmiotu nie będącego osobą fizyczną     **- dotyczy podmiotu będącego osobą fizyczną </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td align="left" colspan="4" height="27" valign="top"> <b>9. Rodzaj podmiotu (zaznaczyć właściwy kwadrat): </b> </td> </tr> <tr> <td align="left" valign="top">1. Podmiot niebędący osobą fizyczną <br/> <xsl:if test="//@typeOfTaxpayer and normalize-space(//@typeOfTaxpayer)='N'"> <div align="right" class="cz12" valign="top"> <b>X</b> </div> </xsl:if> </td> <td align="left" valign="top">2. Osoba fizyczna <br/> <xsl:if test="//@typeOfTaxpayer and normalize-space(//@typeOfTaxpayer)='F'"> <div align="right" class="cz12" valign="top"> <b>X</b> </div> </xsl:if> </td> <td align="left" valign="top">3. Podatnik <br/> <xsl:if test="//@podatnik and normalize-space(//@podatnik)='true'"> <div align="right" class="cz12" valign="top"> <b>X</b> </div> </xsl:if> </td> <td align="left" valign="top">4. Płatnik <br/> <xsl:if test="//@platnik and normalize-space(//@platnik)='true'"> <div align="right" class="cz12" valign="top"> <b>X</b> </div> </xsl:if> </td> </tr> <tr> <td align="left" colspan="4" valign="top"> <b>10.Nazwa pełna, REGON* /Nazwisko, pierwsze imię, data urodzenia **</b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@fullName"/> </span> <span class="cz18"> <xsl:value-of select="//@REGON"/> </span> <span class="cz18"> <xsl:value-of select="//@firstName"/> </span> <span class="cz18"> <xsl:value-of select="//@surname"/> </span> <span class="cz18"> <xsl:value-of select="//@dateOfBirth"/> </span> <span class="cz18"> <xsl:value-of select="//@PESEL"/> </span> </td> </tr> <!-- <tr>  <td width="40"  bgcolor="#CCCCCC"> </td> <td colspan = "4" align="left" valign="top"><b>11. Urząd skarbowy, przy pomocy którego właściwy dla podatnika/płatnika naczelnik urzedu skarbowego wykonuje swoje zadania</b><br></br><br></br> <span class="cz18"><xsl:value-of select="//@taxOffice"/></span>  </td>  </tr> --> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. KWOTY PODATKU --> <xsl:template match="ns1:Header | vat14:*" mode="KwotaPodatku"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="5"> <span class="nag1">C. KWOTA PODATKU DLA TOWARÓW I USŁUG OD WEWNĄTRZWSPÓLNOTOWEGO NABYCIA PALIW SILNIKOWYCH</span> <br/> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="4" width="40"> <p/> <p/> <p/> <p/> </td> <td align="left" bgcolor="#CCCCCC" height="42" valign="top" width="610"> <b>Razem podatek w zł. Podatek do zapłaty na rachunek izby celnej właściwej w zakresie wpłat akcyzy, ogółem za miesiąc, którego dotyczy deklaracja. </b> Kwota podatku od towarów i usług z poz. 10 załącznika VAT-14/A. W przypadku, gdy załączników VAT-14/A jest więcej niż 1, należy wpisać sumę kwot z poz. 10 wszystkich załączników VAT-14/A.</td> <td align="left" colspan="2" valign="top" width="283"> <b>11.</b> <br/> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@totalAmountOfTax),'# ##0')"/> </div> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:template match="*" mode="OswPodatnika"> <xsl:if test="ns1:* | ns3:* | vat14:* | tp:*"> <table border="1" height="210" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="3"> <b> <span class="nag1">D. PODPIS PODATNIKA/PŁATNIKA LUB OSOBY ICH REPREZENTUJĄCEJ</span> </b> <br/> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td height="37" width="402"> <b>12. Imię </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repFirstName"/> </span> </td> <td width="491"> <b> 13. Nazwisko </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repSurname "/> </span> </td> </tr> <tr align="left" valign="top"> <td height="39"> <b>16. Data wypełnienia deklaracji (dzień-miesiąc-rok) </b> <br/> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@declarationDate"/> </span> </td> <td> <b> 14. Podpis (i pieczątka) podatnika lub osoby reprezentującej podatnika </b> </td> </tr> <tr align="left" valign="top"> <td colspan="2" height="70"> <b>15. Numer telefonu i adres e-mail podatnika lub osoby reprezentującej podatnika </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@phone"/>, <xsl:value-of select="ns1:Statement/ns3:representative/@email"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADNOTACJI--> <xsl:template match="*" mode="Adnotacje"> <xsl:if test="ns1:* | vat14:*"> <table border="1" height="165" width="955"> <tr bgcolor="#CCCCCC"> <td class="nag1" colspan="3" height="36"> E. ADNOTACJE URZĘDU CELNEGO </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td rowspan="2" width="40"/> <td colspan="2" height="72"> <b>17. Uwagi urzędu celnego <br/> <br/> <br/> <br/> <br/> <br/> <br/> </b> </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td height="49" width="472"> <b>18. Identyfikator przyjmującego formularz <br/> <br/> <br/> </b> <p/> </td> <td width="421"> <b>19. Podpis przyjmującego formularz </b> </td> </tr> </table> <p>1) Załącznik VAT-14/A stanowi integralną część deklaracji VAT-14. <br/> 2) Zgodnie z art. 81 ustawy z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa (Dz. U. z 2015 r. poz. 613, z późn. zm.).</p> <br/> <br/> </xsl:if> </xsl:template> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:template match="*" mode="Pouczenie"> <xsl:if test="ns1:* | vat14:*"> <table width="955"> <tr> <td> <p align="center"> <b> Pouczenie: </b> </p> <p>W przypadku niewpłacenia w obowiązujacym terminie kwoty z poz. 12 lub wpłacenia jej w niepełnej wysokości, niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2016 r. poz. 599, z późn. zm.).<p>Za podanie nieprawdy lub zatajenie prawdy i przez to narażenie podatku na uszczuplenie grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym.</p> </p> </td> </tr> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">VAT-14</span> <sub style="cz9">(1)</sub> <b style="nag1">/1</b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:template match="*" mode="ObjasnieniaAkc"> <xsl:if test="ns1:* | vat14:*"> <table width="955"> <tr> <td> <p align="center"> <b>Objaśnienia do:</b> <b/> </p> <p>1) Deklaracji VAT-14:<br/> <p>- w <b>poz. 6</b> należy wpisać liczbę dołączonych załączników VAT-14/A,</p> <p>- jeżeli składający deklarację występuje w charakterze podatnika i płatnika, to składa 1-ną deklarację za dany okres rozliczeniowy; należy zaznaczyć w <b>poz. 9</b> kwadrat nr 3 i 4,</p> <p>- w <b>poz. 11</b> należy wpisać urząd skarbowy właściwy dla składającego deklarację ze względu na rozliczenie z tytułu podatku od towarów i usług,</p> <p>- w <b>poz. 12</b> należy wpisać łączną kwotę podatku stanowiącą sumę kwot cząstkowych, które winny być wpłacone zgodnie z art. 103 ust. 4a i 4b ustawy,</p> <p>- w <b>poz. 16</b> podanie informacji jest dobrowolne.</p> <p>2) Załącznika VAT-14/A <b>„ROZLICZENIE WEWNĄTRZWSPÓLNOTOWEGO NABYCIA PALIW SILNIKOWYCH”:</b> </p> <br/> <p>- tabelę z części <b>B</b> załącznika należy wypełnić chronologicznie według dat transakcji,</p> <p>- jeżeli wystąpi konieczność wypełnienia więcej niż jednego załącznika w <b>poz.4</b> należy oznaczyć odpowiednio kolejne numery załaczników (np. 1, 2, 3),</p> <p>- w przypadku deklaracji składanej za pomocą środków komunikacji elektronicznej (interaktywnej) wiersze tabeli części B załącznika stanowią listę rozwijalną,</p> <p>- <b>kolumnę b, c,</b> oraz <b>j</b> wypełnia się tylko wówczas jeżeli składający deklarację występuje w charakterze płatnika,</p> <p>- jeżeli składający deklarację występuje w charakterze podatnika i płatnika (w poz. 5 zaznaczono kwadrat nr 3 i 4), to w przypadku transakcji dokonanej na własną rzecz w <b>kolumnie d</b> należy zaznaczyć kwadrat znakiem X; w pozostałych przypadkach kolumny d nie wypełnia się,</p> <p>- <b>kolumnę e</b> wypełnia się tylko w przypadku zastosowania procedury zawieszenia poboru akcyzy,</p> <p>- w <b>kolumnie f</b> należy wpisać datę transakcji powodującej powstanie obowiązku zapłaty kwoty podatku; przez datę transakcji należy rozumieć datę, od której liczy się termin wpłaty kwoty podatku zgodnie z art. 103 ust. 5a i 5b ustawy,</p> <p>- w <b>kolumnie h</b> należy wpisać wartość transakcji bez kwoty podatku, stanowiącą podstawę opodatkowania; jeżeli w danym dniu było więcej transakcji z tym samym kontrahentem, z zastrzeżeniem, że w przypadku płatnika transakcje te są rozliczane na rzecz tego samego podatnika, to można podać sumę wartości tych transakcji (z tego samego dnia), pod warunkiem, że transakcje te dotyczą wyrobu o tym samym kodzie CN,</p> <p>- w <b>kolumnie i</b> należy podać kwotę podatku należnego od wyszczególnionych w kolumnie h transakcji,</p> <p>- w <b>kolumnie j</b> należy wpisać kwotę zryczałtowanego wynagrodzenia płatnika z tytułu terminowego wpłacania podatku zgodnie z art. 28 ustawy – Ordynacja podatkowa,</p> <p>- w <b>kolumnie k</b> w ostatnim wierszu dla transakcji z tego samego dnia należy wpisać łączną kwotę podatku dla transakcji z tego samego dnia po pomniejszeniu o łączną kwotę zryczałtowanego wynagrodzenia płatnika z kolumny j dla transakcji z tego samego dnia, które przysługuje płatnikowi zgodnie z art. 28 ustawy – Ordynacja podatkowa; jeżeli rozliczenia dokonuje podatnik kwota podatku wykazana w kolumnie k równa się kwocie podatku wykazanej w kolumnie <b>i</b>,</p> <p>- w przypadku, gdy załącznik VAT-14/A jest jeden, to kwota z poz. 8 powinna być równa sumie kwot z poz. 9 i 10; jeżeli załączników jest więcej niż jeden, to suma kwot z poz. 8 wszystkich załączników powinna być równa sumie kwot z poz. 9 i 10 wszystkich załączników.</p> </p> </td> </tr> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">VAT-14</span> <sub style="cz9">(1)</sub> <b style="nag1">/2</b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  RODZAJU DEKLARACJI --> <xsl:template match="*" mode="rodz_dekl_zal"> <xsl:if test="ns1:* | vat14:*"> <table border="1" width="956"> <tr> <td colspan="3" height="40"> <span class="nag1">VAT-14/A</span> </td> </tr> <tr> <td> <div align="center"> <span class="nag1">ROZLICZENIE WEWNĄTRZWSPÓLNOTOWEGO NABYCIA PALIW SILNIKOWYCH</span> <br/> <span class="nag1"/> </div> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:template match="*" mode="rok_mc_zal"> <table border="1" width="955"> <tr> <td height="49" width="227"/> <td align="left" valign="top" width="135"> <b>2. Miesiac</b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(//@period,6,7)"/> </div> </td> <td align="left" valign="top" width="131"> <b>3. Rok </b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(//@period,1,4)"/> </div> </td> <td width="226"/> <td align="left" valign="top" width="226"> <b>4. Nr załącznika</b> <br/> <div align="center" class="cz18"> <xsl:value-of select=".//@formNo"/> </div> </td> </tr> </table> <table width="955"> <tr bgcolor="#CCCCCC"> <td> <span class="cz12">Załacznik VAT-14A stanowi integralną cześć deklaracji VAT-14.</span> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:template match="*" mode="DanePodatnika_Zal"> <xsl:if test="ns1:* | vat14:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="5"> <span class="nag1">A. DANE IDENTYFIKACYJNE PODATNIKA/PŁATNIKA</span> <br/> *- dotyczy podmiotu nie będącego osobą fizyczną     **- dotyczy podmiotu będącego osobą fizyczną </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td align="left" colspan="4" height="27" valign="top"> <b>5. Rodzaj podmiotu (zaznaczyć właściwy kwadrat): </b> </td> </tr> <tr> <td align="left" valign="top">1. Podmiot niebędący osobą fizyczną <br/> <xsl:if test="//@typeOfTaxpayer and normalize-space(//@typeOfTaxpayer)='N'"> <div align="right" class="cz12" valign="top"> <b>X</b> </div> </xsl:if> </td> <td align="left" valign="top">2. Osoba fizyczna <br/> <xsl:if test="//@typeOfTaxpayer and normalize-space(//@typeOfTaxpayer)='F'"> <div align="right" class="cz12" valign="top"> <b>X</b> </div> </xsl:if> </td> <td align="left" valign="top">3. Podatnik <br/> <xsl:if test="//@podatnik and normalize-space(//@podatnik)='true'"> <div align="right" class="cz12" valign="top"> <b>X</b> </div> </xsl:if> </td> <td align="left" valign="top">4. Płatnik <br/> <xsl:if test="//@platnik and normalize-space(//@platnik)='true'"> <div align="right" class="cz12" valign="top"> <b>X</b> </div> </xsl:if> </td> </tr> <tr> <td align="left" colspan="4" valign="top"> <b>6.Nazwa pełna, REGON* /Nazwisko, pierwsze imię, data urodzenia **</b> <br/> <br/> <br/> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@fullName"/> </span> <span class="cz18"> <xsl:value-of select="//@REGON"/> </span> <span class="cz18"> <xsl:value-of select="//@firstName"/> </span> <span class="cz18"> <xsl:value-of select="//@surname"/> </span> <span class="cz18"> <xsl:value-of select="//@dateOfBirth"/> </span> <span class="cz18"> <xsl:value-of select="//@PESEL"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM --> <xsl:template match="*" mode="NowaStrona_Zal"> <!-- tymczasowo --> <!-- ZNAK KONCA STRONY DO WYDRUKU --> <div style="page-break-before: always"> <!-- <table width="955" border="1"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"><b><xsl:apply-templates select="." mode = "stopka"/></b></span> </td> </tr> </table> --> </div> </xsl:template> <!-- SZABLON DOT. WYROBOW --> <xsl:template match="ns1:* | vat14:*" mode="Wyroby"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td class="nag1" colspan="11">B. ROZLICZENIE WEWNĄTRZWSPÓLNOTOWEGO NABYCIA PALIW SILNIKOWYCH</td> </tr> <tr align="center" bgcolor="#CCCCCC" valign="middle"> <td>Lp.</td> <td>Nazwa podatnika, na rzecz którego płatnik dokonuje rozliczenia</td> <td>NIP podatnika </td> <td>Transakcja własna</td> <td>Numer akcyzowy:składu podatkowego/<br/>zarejestrowanego odbiorcy</td> <td>Data transakcji   (dzień-miesiąc-rok) </td> <td>Ośmiocyfrowy kod CN</td> <td>Wartość transakcji w zł</td> <td>Kwota podatku należnego w zł</td> <td>Kwota zryczałtowanego wynagrodzenia płatnika w zł</td> <td>Kwota podatku należnego pomniejszona o zryczałtowane wynagrodzenie płatnika w zł</td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td> <div align="center">a</div> </td> <td> <div align="center">b</div> </td> <td> <div align="center">c</div> </td> <td> <div align="center">d</div> </td> <td> <div align="center">e</div> </td> <td> <div align="center">f</div> </td> <td> <div align="center">g</div> </td> <td> <div align="center">h</div> </td> <td> <div align="center">i</div> </td> <td> <div align="center">j</div> </td> <td> <div align="center">k</div> </td> </tr> <xsl:for-each select="//ns1:Item | //vat14:Item"> <tr align="left" valign="top"> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@id"/> </div> </td> <td> <div align="left" class="cz12" valign="top"> <xsl:value-of select="@nameOfTaxpayer"/> </div> </td> <td> <div align="right" class="cz12" valign="top"> <xsl:value-of select="@nip"/> </div> </td> <td> <xsl:if test="@selfTrade and normalize-space(@selfTrade)='true'"> <div align="right" class="cz12" valign="top"> <b>X</b> </div> </xsl:if> </td> <td> <div align="right" class="cz12" valign="top"> <xsl:value-of select="@userNo"/> </div> </td> <td> <div align="left" class="cz12" valign="top"> <xsl:value-of select="@transactionDate"/> </div> </td> <td> <div align="right" class="cz12" valign="top"> <xsl:value-of select="@codeCN"/> </div> </td> <td> <div align="right" class="cz12" valign="top"> <xsl:value-of select="@transactionValue"/> </div> </td> <td> <div align="right" class="cz12" valign="top"> <xsl:value-of select="@amountofTax"/> </div> </td> <td> <div align="right" class="cz12" valign="top"> <xsl:value-of select="@amountofFlatSalary"/> </div> </td> <td> <div align="right" class="cz12" valign="top"> <xsl:value-of select="@taxChargeable"/> </div> </td> </tr> </xsl:for-each> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" colspan="7"> <b>Razem suma kwot z poszczególnych wierszy</b> </td> <td> <b>7.</b> <br/> <div align="right" class="cz12" valign="top"> <xsl:value-of select="format-number(number(*/@transactionsValueTotal),'# ##0')"/> </div> </td> <td> <b>8.</b> <br/> <div align="right" class="cz12" valign="top"> <xsl:value-of select="format-number(number(*/@amountofTaxTotal),'# ##0')"/> </div> </td> <td> <b>9.</b> <br/> <div align="right" class="cz12" valign="top"> <xsl:value-of select="format-number(number(*/@amountofFlatSalaryTotal),'# ##0')"/> </div> </td> <td> <b>10.</b> <br/> <div align="right" class="cz12" valign="top"> <xsl:value-of select="format-number(number(*/@totalAmountOfTax),'# ##0')"/> </div> </td> </tr> </table> <table width="955"> <tr> <td> <sup>2)</sup>W przypadku wykazywania ubytków wyrobów akcyzowych (przekraczających normy dopuszczalnych ubytków) lub całkowitego zniszczenia  wyrobów, w kolumnie "b", obok nazwy grupy wyrobów należy wpisać odpowiednio: "ubytki" lub "całkowite zniszczenie".<br/> <sup>3)</sup> Wartość opałowa odpowiadająca ilości wyrobów węglowych będąca przedmiotem opodatkowania.</td> </tr> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">VAT-14/A</span> <sub style="cz9">(1)</sub> <b style="nag1">/1</b> </td> </tr> </table> </xsl:template> <!-- KONIEC all AG--> </xsl:stylesheet>